## ✅ **System Planning Overview**

### 🔧 **Technology Stack**

* **Frontend (Mobile App)**: Flutter (Dart)
* **Backend API**: raw PHP
* **Database**: MySQL 
* **Map Services**: OpenStreetMap
---

## 📱 1. **Flutter Mobile Application Modules**

### A. **Authentication Module**

* User sign-up & login (email, phone number)
* Mechanic/garage registration (different role)


### B. **Breakdown Reporting Module**

* Button to "Report Breakdown"
* Auto-detect current GPS location
* Add optional description (e.g., “flat tire”, “engine overheating”)
* Upload image (optional)

### C. **Mechanic/Garage Discovery**

* Show **nearby mechanics/garages** on a map
* Display:

  * Name
  * Distance from user
  * Estimated time of arrival
  * Rating and reviews
* Option to **filter by type of service**

### D. **Mechanic Details and Booking**

* Profile page of a mechanic/garage
* Services offered, availability, pricing (optional)
* Button to **"Request Assistance"**
* Real-time tracking of mechanic’s arrival

### E. **History & Tracking**

* Show breakdown history with:

  * Date
  * Location
  * Mechanic assigned
  * Status

---

## 🌐 2. **PHP Backend API Modules**

### A. **User Management**

* Register/login users
* Assign roles: Driver / Mechanic / Admin

### B. **Location & Map Services**

* Save & fetch user locations
* Fetch nearby garages/mechanics 

### C. **Breakdown Request System**

* Log new breakdown requests
* Update request status: Pending, Accepted, En Route, Completed
* Assign mechanics to requests

### D. **Mechanic/Garage Management**

* Register garages and mechanics
* Store service categories, locations, availability


---

## 🧱 3. **Database Schema Sketch**

### Tables:

1. `users` — (id, name, phone, email, password, role, rating, etc.)
2. `mechanics` — (id, user\_id, garage\_name, location, services, status)
3. `breakdowns` — (id, user\_id, location, type, image, status, mechanic\_id)
4. `services` — (id, name, description)

---

## 🗺️ 4. **Map & Location Planning**

### OpenStreetMap integration:

* Show user's location
* Show mechanics as pins
* Clicking on a mechanic shows details and "Request Help" button
* Directions via Maps link (Google Maps intent or embedded navigation)

---

## ✅ 5. **Development Phases**

### **Phase 1: Core Features**

* User authentication
* Breakdown reporting
* Nearby mechanic discovery
* Mechanic assignment

### **Phase 2: Enhanced Features**

* Mechanic Real-time tracking
* Mechanic profile pages

### **Phase 3: Add-ons**

* Offline support (caching last known garages)